//Created: September 18, 2008
//Revised: September 18, 2008

#include "Variable.h"

using namespace std;

Variable::Variable(const char * _id, const char * _value) {
	if(_id == NULL) {
		this->_id = new char[1];
		this->_id[0] = '\0';
	}
	else {
		this->_id = new char[strlen(_id) + 1];
		strcpy(this->_id, _id);
	}
	
	if(_value == NULL) {
		this->_value = new char[1];
		this->_value[0] = '\0';
	}
	else {
		this->_value = new char[strlen(_value) + 1];
		strcpy(this->_value, _value);
	}
}

Variable::Variable(const Variable & x) {
	this->_id = new char[strlen(x._id) + 1];
	strcpy(this->_id, x._id);
	
	this->_value = new char[strlen(x._value) + 1];
	strcpy(this->_value, x._value);
}

Variable & Variable::operator = (const Variable & x) {
	delete [] this->_id;
	delete [] this->_value;

	this->_id = new char[strlen(x._id) + 1];
	strcpy(this->_id, x._id);

	this->_value = new char[strlen(x._value) + 1];
	strcpy(this->_value, x._value);

	return *this;
}

Variable::~Variable(void) {
	delete [] this->_id;
	delete [] this->_value;
}

void Variable::id(const char * _id) {
	delete [] this->_id;
	
	if(_id == NULL) {
		this->_id = new char[1];
		this->_id[0] = '\0';
	}
	else {
		this->_id = new char[strlen(_id) + 1];
		strcpy(this->_id, _id);
	}
}

void Variable::value(const char * _value) {
	delete [] this->_value;
	
	if(_value == NULL) {
		this->_value = new char[1];
		this->_value[0] = '\0';
	}
	else {
		this->_value = new char[strlen(_value) + 1];
		strcpy(this->_value, _value);
	}
}

char * Variable::id() const  { return this->_id; }
char * Variable::value() const  { return this->_value; }

bool Variable::operator == (const Variable & x) const {
	return strcasecmp(this->_id, x._id) == 0;
}

bool Variable::operator != (const Variable & x) const {
	return !operator == (x);
}

void Variable::printOn(ostream & o) const {
	o << this->_id << ": " << this->_value;
}

ostream & operator << (ostream & o, const Variable & x) {
	x.printOn(o);
	return o;
}
